| package |
package := Package name: 'CU PackageResourceLocator'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.002'.


package classNames
	add: #PackageResourceLocator;
	yourself.

package methodNames
	add: #PackageRelativeFileLocator -> #hack;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	yourself).

package!

"Class Definitions"!

RelativeFileLocator subclass: #PackageResourceLocator
	instanceVariableNames: 'packageName subFolder'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!PackageRelativeFileLocator methodsFor!

hack
	self become: (PackageResourceLocator packageNamed: packageName).! !
!PackageRelativeFileLocator categoriesFor: #hack!public! !

"End of package definition"!

"Source Globals"!

"Classes"!

PackageResourceLocator guid: (GUID fromString: '{A0967660-4595-4116-AD86-89437DD7043B}')!
PackageResourceLocator comment: 'Copyright  Chris Uppal, 2002, 2005.
chris.uppal@metagnostic.org

PackageResourceLocator is a file locator that works relative to a specific sub-folder of the folder containing a named package.

If the file locator is used in a deployed app, then it falls back to looking in the same subfolder, but this time image-relative.

The point of the sub-folder aspect is that (when compared to my previous PackageRelativeFileLocator, which this is intended largely to replace) you can just say:

	locator := PackageResourceLocator package: aPackage.
	icon := Icon fromFile: ''MyIcon.ic'' usingLocator: locator.

rather than:

	locator := PackageRelativeFileLocator package: aPackage.
	icon := Icon fromFile: ''Resources\MyIcon.ico'' usingLocator: locator.

This has two advantages.  One is the relatively trivial saving in typing.  The more imporant one is that the resulting Icon will have an #identifier which is a simple name, ''MyIcon.ico'', rather than including the ''Resources\'' bit too.  This means that at runtime, if the icon is not found in the filesystem, the default icon loading will fall back to looking in the executable''s own resources for ''MyIcon.ico'', since that is a legitimage resource name, if you have added such a resource to your deployed executable, then it''ll be found.   The reason we have to avoid the ''Resources\'' bit is that ''Resources\MyIcon.ico'' is /not/ a legal resource name.

	-- chris'!
!PackageResourceLocator categoriesForClass!Unclassified! !
!PackageResourceLocator methodsFor!

basePath
	"since this stuff isn't bloody documented, I can only guess at what this method
	is *supposed* to do.  What it actually *does* is answer the resources sub-directory 
	of the directory where our package lives"

	| folder |

	folder := self package
			ifNil: [SessionManager current imageBase]
			ifNotNil: [:it | File splitPathFrom: it packageFileName].

	^ File composePath: folder subPath: subFolder.!

package
	"answer the Package relative to the location of which we will handle file paths or nil if the package
	doesn't exist or Package has been stripped out of the image"

	^ Smalltalk at: #Package ifPresent: [:it | it manager packageNamed: packageName ifNone: [nil]].!

packageName
	"answer the String name of the Package relative to the location of which we will handle file paths"

	^ packageName.!

packageName: aString
	"private -- set the String name of the Package relative to the location of which we will handle file paths"

	packageName := aString.!

printOn: aStream
	"append a developer friendly representation of ourself to the given stream.
	This implementation allows the reciever to be recreated (e.g. in an Inspector)"

	aStream
		display: self class;
		display: ' packageNamed: ';
		print: packageName.

	subFolder = self class defaultSubFolder ifFalse:
		[aStream
			display: ' subFolder: ';
			print: subFolder].


!

subFolder
	"answer the String name of sub-folder where we will look for resources"

	^ packageName.!

subFolder: aString
	"private -- set the String name of the sub-folder within which we will look for resources"

	subFolder := aString.! !
!PackageResourceLocator categoriesFor: #basePath!public! !
!PackageResourceLocator categoriesFor: #package!public! !
!PackageResourceLocator categoriesFor: #packageName!public! !
!PackageResourceLocator categoriesFor: #packageName:!public! !
!PackageResourceLocator categoriesFor: #printOn:!public! !
!PackageResourceLocator categoriesFor: #subFolder!public! !
!PackageResourceLocator categoriesFor: #subFolder:!public! !

!PackageResourceLocator class methodsFor!

defaultSubFolder
	"answer the default sub-folder where we expect to find resources"

	^ 'Resources/'.!

package: aPackage
	"answer an instance that is configured to interpret files relative to
	the 'Resources/' sub-folder of the folder containing aPackage.
	It is an error if the package has not yet been saved.
	Note that it doesn't hold onto a reference to the package itself,
	just the name, and if (e.g. at runtime) the package is not found then
	it'll default to looking for the resoure in <image>/Resources/"

	^ self package: aPackage subFolder: 'Resources/'.
!

package: aPackage subFolder: aSubfolderName
	"answer an instance that is configured to interpret files relative to
	the named sub-folder of the folder containing aPackage.
	It is an error if the package has not yet been saved.
	Note that it doesn't hold onto a reference to the package itself,
	just the name, and if (e.g. at runtime) the package is not found then
	it'll default to looking for the resoure in named sub-folder of the image
	directory"

	^ self packageNamed: aPackage name subFolder: aSubfolderName.
!

packageNamed: aString
	"answer an instance that is configured to interpret files relative to
	the 'Resources/' sub-folder of the folder containing aPackage.
	Note that it doesn't hold onto a reference to the package itself,
	just the name, and if (e.g. at runtime) the package is not found then
	it'll default to looking for the resoure in <image>/Resources/"

	^ self packageNamed: aString subFolder: 'Resources/'.!

packageNamed: aString subFolder: aSubfolderName
	"answer an instance that is configured to interpret files relative to
	the named sub-folder of the folder containing aPackage.
	Note that it doesn't hold onto a reference to the package itself,
	just the name, and if (e.g. at runtime) the package is not found then
	it'll default to looking for the resoure in named subfolder of the image
	directory"

	^ (super new)
		packageName: aString;
		subFolder: aSubfolderName;
		yourself.
! !
!PackageResourceLocator class categoriesFor: #defaultSubFolder!public! !
!PackageResourceLocator class categoriesFor: #package:!public! !
!PackageResourceLocator class categoriesFor: #package:subFolder:!public! !
!PackageResourceLocator class categoriesFor: #packageNamed:!public! !
!PackageResourceLocator class categoriesFor: #packageNamed:subFolder:!public! !

"Binary Globals"!

